<?php
class Vecinos{
 
    private $conn;
    private $table_name = "vecinos";
	public $pageNo = 1;
	public  $no_of_records_per_page=30;
	
public $id;
public $nombre;
public $apellido;
public $edad;
public $fecha_nacimiento;
public $rut;
public $profesion;
public $direccion;
public $telefono;
public $email;
public $vigilante;
public $foto;
public $clave_app;
public $token;
public $anexo1_nombre;
public $anexo1_telefono;
public $anexo2_nombre;
public $anexo2_telefono;
public $anexo3_nombre;
public $anexo3_telefono;
public $activo;
    
    public function __construct($db){
        $this->conn = $db;
    }

	function total_record_count() {
		$query = "select count(1) as total from ". $this->table_name ."";
		$stmt = $this->conn->prepare($query);
		$stmt->execute();
		$row = $stmt->fetch(PDO::FETCH_ASSOC);
		return $row['total'];
	}

	function search_count($searchKey) {
		$query = "SELECT count(1) as total FROM ". $this->table_name ." t  WHERE LOWER(t.nombre) LIKE ? OR LOWER(t.apellido) LIKE ?  OR LOWER(t.edad) LIKE ?  OR LOWER(t.fecha_nacimiento) LIKE ?  OR LOWER(t.rut) LIKE ?  OR LOWER(t.profesion) LIKE ?  OR LOWER(t.direccion) LIKE ?  OR LOWER(t.telefono) LIKE ?  OR LOWER(t.email) LIKE ?  OR LOWER(t.vigilante) LIKE ?  OR LOWER(t.foto) LIKE ?  OR LOWER(t.clave_app) LIKE ?  OR LOWER(t.token) LIKE ?  OR LOWER(t.anexo1_nombre) LIKE ?  OR LOWER(t.anexo1_telefono) LIKE ?  OR LOWER(t.anexo2_nombre) LIKE ?  OR LOWER(t.anexo2_telefono) LIKE ?  OR LOWER(t.anexo3_nombre) LIKE ?  OR LOWER(t.anexo3_telefono) LIKE ?  OR LOWER(t.activo) LIKE ? ";
		$stmt = $this->conn->prepare($query);
		$searchKey="%".strtolower($searchKey)."%";
		
$stmt->bindParam(1, $searchKey);
$stmt->bindParam(2, $searchKey);
$stmt->bindParam(3, $searchKey);
$stmt->bindParam(4, $searchKey);
$stmt->bindParam(5, $searchKey);
$stmt->bindParam(6, $searchKey);
$stmt->bindParam(7, $searchKey);
$stmt->bindParam(8, $searchKey);
$stmt->bindParam(9, $searchKey);
$stmt->bindParam(10, $searchKey);
$stmt->bindParam(11, $searchKey);
$stmt->bindParam(12, $searchKey);
$stmt->bindParam(13, $searchKey);
$stmt->bindParam(14, $searchKey);
$stmt->bindParam(15, $searchKey);
$stmt->bindParam(16, $searchKey);
$stmt->bindParam(17, $searchKey);
$stmt->bindParam(18, $searchKey);
$stmt->bindParam(19, $searchKey);
$stmt->bindParam(20, $searchKey);
		$stmt->execute();
		$row = $stmt->fetch(PDO::FETCH_ASSOC);
		return $row['total'];
	}
	
	function search_record_count($columnArray,$orAnd){
		$where="";
		$paramCount = 1;
		foreach ($columnArray as $col) {
			$pre_param = "P" . $paramCount . "_";
			$columnName=htmlspecialchars(strip_tags($col->columnName));
			$columnLogic=$col->columnLogic;
			if($where==""){
				$where="LOWER(t.".$columnName . ") ".$columnLogic." :".$pre_param.$columnName;
			}else{
				$where=$where." ". $orAnd ." LOWER(t." . $columnName . ") ".$columnLogic." :".$pre_param.$columnName;
			}
			 $paramCount++;
		}
		$query = "SELECT count(1) as total FROM ". $this->table_name ." t  WHERE ".$where."";
		
		$stmt = $this->conn->prepare($query);
		$paramCount=1;
		foreach ($columnArray as $col) {
			$columnName=htmlspecialchars(strip_tags($col->columnName));
		if(strtoupper($col->columnLogic)=="LIKE"){
		$columnValue="%".strtolower($col->columnValue)."%";
		}else{
		$columnValue=strtolower($col->columnValue);
		}
			$stmt->bindValue(":".$pre_param.$columnName, $columnValue);
			$paramCount++;
		}
		
		$stmt->execute();
		$row = $stmt->fetch(PDO::FETCH_ASSOC);
		 $num = $stmt->rowCount();
		if($num>0){
			return $row['total'];
		}else{
			return 0;
		}
	}
	function read(){
		if(isset($_GET["pageNo"])){
			$this->pageNo=$_GET["pageNo"];
		}
		$offset = ($this->pageNo-1) * $this->no_of_records_per_page; 
		$query = "SELECT  t.* FROM ". $this->table_name ." t  LIMIT ".$offset." , ". $this->no_of_records_per_page."";
		$stmt = $this->conn->prepare($query);
		$stmt->execute();
		return $stmt;
	}
	function search($searchKey){
		if(isset($_GET["pageNo"])){
		$this->pageNo=$_GET["pageNo"];
		}
		$offset = ($this->pageNo-1) * $this->no_of_records_per_page; 
		$query = "SELECT  t.* FROM ". $this->table_name ." t  WHERE LOWER(t.nombre) LIKE ? OR LOWER(t.apellido) LIKE ?  OR LOWER(t.edad) LIKE ?  OR LOWER(t.fecha_nacimiento) LIKE ?  OR LOWER(t.rut) LIKE ?  OR LOWER(t.profesion) LIKE ?  OR LOWER(t.direccion) LIKE ?  OR LOWER(t.telefono) LIKE ?  OR LOWER(t.email) LIKE ?  OR LOWER(t.vigilante) LIKE ?  OR LOWER(t.foto) LIKE ?  OR LOWER(t.clave_app) LIKE ?  OR LOWER(t.token) LIKE ?  OR LOWER(t.anexo1_nombre) LIKE ?  OR LOWER(t.anexo1_telefono) LIKE ?  OR LOWER(t.anexo2_nombre) LIKE ?  OR LOWER(t.anexo2_telefono) LIKE ?  OR LOWER(t.anexo3_nombre) LIKE ?  OR LOWER(t.anexo3_telefono) LIKE ?  OR LOWER(t.activo) LIKE ?  LIMIT ".$offset." , ". $this->no_of_records_per_page."";
		$stmt = $this->conn->prepare($query);
		$searchKey="%".strtolower($searchKey)."%";
		
$stmt->bindParam(1, $searchKey);
$stmt->bindParam(2, $searchKey);
$stmt->bindParam(3, $searchKey);
$stmt->bindParam(4, $searchKey);
$stmt->bindParam(5, $searchKey);
$stmt->bindParam(6, $searchKey);
$stmt->bindParam(7, $searchKey);
$stmt->bindParam(8, $searchKey);
$stmt->bindParam(9, $searchKey);
$stmt->bindParam(10, $searchKey);
$stmt->bindParam(11, $searchKey);
$stmt->bindParam(12, $searchKey);
$stmt->bindParam(13, $searchKey);
$stmt->bindParam(14, $searchKey);
$stmt->bindParam(15, $searchKey);
$stmt->bindParam(16, $searchKey);
$stmt->bindParam(17, $searchKey);
$stmt->bindParam(18, $searchKey);
$stmt->bindParam(19, $searchKey);
$stmt->bindParam(20, $searchKey);
		$stmt->execute();
		return $stmt;
	}
	function searchByColumn($columnArray,$orAnd){
		if(isset($_GET["pageNo"])){
		$this->pageNo=$_GET["pageNo"];
		}
		$offset = ($this->pageNo-1) * $this->no_of_records_per_page; 
		$where="";
		$paramCount = 1;
		foreach ($columnArray as $col) {
			$pre_param = "P" . $paramCount . "_";
			$columnName=htmlspecialchars(strip_tags($col->columnName));
			$columnLogic=$col->columnLogic;
			if($where==""){
				$where="LOWER(t.".$columnName . ") ".$columnLogic." :".$pre_param.$columnName;
			}else{
				$where=$where." ". $orAnd ." LOWER(t." . $columnName . ") ".$columnLogic." :".$pre_param.$columnName;
			}
			 $paramCount++;
		}
		$query = "SELECT  t.* FROM ". $this->table_name ." t  WHERE ".$where." LIMIT ".$offset." , ". $this->no_of_records_per_page."";
		
		$stmt = $this->conn->prepare($query);
		$paramCount=1;
		foreach ($columnArray as $col) {
			$pre_param = "P" . $paramCount . "_";
			$columnName=htmlspecialchars(strip_tags($col->columnName));
			if(strtoupper($col->columnLogic)=="LIKE"){
			$columnValue="%".strtolower($col->columnValue)."%";
			}else{
			$columnValue=strtolower($col->columnValue);
			}
			$stmt->bindValue(":".$pre_param.$columnName, $columnValue);
			$paramCount++;
		}
		
		$stmt->execute();
		return $stmt;
	}
	
	

	function readOne(){
		$query = "SELECT  t.* FROM ". $this->table_name ." t  WHERE t.id = ? LIMIT 0,1";
		$stmt = $this->conn->prepare($query);
		$stmt->bindParam(1, $this->id);
		$stmt->execute();
		$row = $stmt->fetch(PDO::FETCH_ASSOC);
		$num = $stmt->rowCount();
		if($num>0){
			
$this->id = $row['id'];
$this->nombre = $row['nombre'];
$this->apellido = $row['apellido'];
$this->edad = $row['edad'];
$this->fecha_nacimiento = $row['fecha_nacimiento'];
$this->rut = $row['rut'];
$this->profesion = $row['profesion'];
$this->direccion = $row['direccion'];
$this->telefono = $row['telefono'];
$this->email = $row['email'];
$this->vigilante = $row['vigilante'];
$this->foto = $row['foto'];
$this->clave_app = $row['clave_app'];
$this->token = $row['token'];
$this->anexo1_nombre = $row['anexo1_nombre'];
$this->anexo1_telefono = $row['anexo1_telefono'];
$this->anexo2_nombre = $row['anexo2_nombre'];
$this->anexo2_telefono = $row['anexo2_telefono'];
$this->anexo3_nombre = $row['anexo3_nombre'];
$this->anexo3_telefono = $row['anexo3_telefono'];
$this->activo = $row['activo'];
		}
		else{
			$this->id=null;
		}
	}
	function create(){
		$query ="INSERT INTO ".$this->table_name." SET nombre=:nombre,apellido=:apellido,edad=:edad,fecha_nacimiento=:fecha_nacimiento,rut=:rut,profesion=:profesion,direccion=:direccion,telefono=:telefono,email=:email,vigilante=:vigilante,foto=:foto,clave_app=:clave_app,token=:token,anexo1_nombre=:anexo1_nombre,anexo1_telefono=:anexo1_telefono,anexo2_nombre=:anexo2_nombre,anexo2_telefono=:anexo2_telefono,anexo3_nombre=:anexo3_nombre,anexo3_telefono=:anexo3_telefono,activo=:activo";
		$stmt = $this->conn->prepare($query);
		
$this->nombre=htmlspecialchars(strip_tags($this->nombre));
$this->apellido=htmlspecialchars(strip_tags($this->apellido));
$this->edad=htmlspecialchars(strip_tags($this->edad));
$this->fecha_nacimiento=htmlspecialchars(strip_tags($this->fecha_nacimiento));
$this->rut=htmlspecialchars(strip_tags($this->rut));
$this->profesion=htmlspecialchars(strip_tags($this->profesion));
$this->direccion=htmlspecialchars(strip_tags($this->direccion));
$this->telefono=htmlspecialchars(strip_tags($this->telefono));
$this->email=htmlspecialchars(strip_tags($this->email));
$this->vigilante=htmlspecialchars(strip_tags($this->vigilante));
$this->foto=htmlspecialchars(strip_tags($this->foto));
$this->clave_app=htmlspecialchars(strip_tags($this->clave_app));
$this->token=htmlspecialchars(strip_tags($this->token));
$this->anexo1_nombre=htmlspecialchars(strip_tags($this->anexo1_nombre));
$this->anexo1_telefono=htmlspecialchars(strip_tags($this->anexo1_telefono));
$this->anexo2_nombre=htmlspecialchars(strip_tags($this->anexo2_nombre));
$this->anexo2_telefono=htmlspecialchars(strip_tags($this->anexo2_telefono));
$this->anexo3_nombre=htmlspecialchars(strip_tags($this->anexo3_nombre));
$this->anexo3_telefono=htmlspecialchars(strip_tags($this->anexo3_telefono));
$this->activo=htmlspecialchars(strip_tags($this->activo));
		
$stmt->bindParam(":nombre", $this->nombre);
$stmt->bindParam(":apellido", $this->apellido);
$stmt->bindParam(":edad", $this->edad);
$stmt->bindParam(":fecha_nacimiento", $this->fecha_nacimiento);
$stmt->bindParam(":rut", $this->rut);
$stmt->bindParam(":profesion", $this->profesion);
$stmt->bindParam(":direccion", $this->direccion);
$stmt->bindParam(":telefono", $this->telefono);
$stmt->bindParam(":email", $this->email);
$stmt->bindParam(":vigilante", $this->vigilante);
$stmt->bindParam(":foto", $this->foto);
$stmt->bindParam(":clave_app", $this->clave_app);
$stmt->bindParam(":token", $this->token);
$stmt->bindParam(":anexo1_nombre", $this->anexo1_nombre);
$stmt->bindParam(":anexo1_telefono", $this->anexo1_telefono);
$stmt->bindParam(":anexo2_nombre", $this->anexo2_nombre);
$stmt->bindParam(":anexo2_telefono", $this->anexo2_telefono);
$stmt->bindParam(":anexo3_nombre", $this->anexo3_nombre);
$stmt->bindParam(":anexo3_telefono", $this->anexo3_telefono);
$stmt->bindParam(":activo", $this->activo);
		$lastInsertedId=0;
		if($stmt->execute()){
			$lastInsertedId = $this->conn->lastInsertId();
			if($lastInsertedId==0 && $this->id!=null){
				$this->readOne();
				if($this->id!=null){
					$lastInsertedId=$this->id;
					}
			}
		}
	
		return $lastInsertedId;
	}
	function update(){
		$query ="UPDATE ".$this->table_name." SET nombre=:nombre,apellido=:apellido,edad=:edad,fecha_nacimiento=:fecha_nacimiento,rut=:rut,profesion=:profesion,direccion=:direccion,telefono=:telefono,email=:email,vigilante=:vigilante,foto=:foto,clave_app=:clave_app,token=:token,anexo1_nombre=:anexo1_nombre,anexo1_telefono=:anexo1_telefono,anexo2_nombre=:anexo2_nombre,anexo2_telefono=:anexo2_telefono,anexo3_nombre=:anexo3_nombre,anexo3_telefono=:anexo3_telefono,activo=:activo WHERE id = :id";
		$stmt = $this->conn->prepare($query);
		
$this->nombre=htmlspecialchars(strip_tags($this->nombre));
$this->apellido=htmlspecialchars(strip_tags($this->apellido));
$this->edad=htmlspecialchars(strip_tags($this->edad));
$this->fecha_nacimiento=htmlspecialchars(strip_tags($this->fecha_nacimiento));
$this->rut=htmlspecialchars(strip_tags($this->rut));
$this->profesion=htmlspecialchars(strip_tags($this->profesion));
$this->direccion=htmlspecialchars(strip_tags($this->direccion));
$this->telefono=htmlspecialchars(strip_tags($this->telefono));
$this->email=htmlspecialchars(strip_tags($this->email));
$this->vigilante=htmlspecialchars(strip_tags($this->vigilante));
$this->foto=htmlspecialchars(strip_tags($this->foto));
$this->clave_app=htmlspecialchars(strip_tags($this->clave_app));
$this->token=htmlspecialchars(strip_tags($this->token));
$this->anexo1_nombre=htmlspecialchars(strip_tags($this->anexo1_nombre));
$this->anexo1_telefono=htmlspecialchars(strip_tags($this->anexo1_telefono));
$this->anexo2_nombre=htmlspecialchars(strip_tags($this->anexo2_nombre));
$this->anexo2_telefono=htmlspecialchars(strip_tags($this->anexo2_telefono));
$this->anexo3_nombre=htmlspecialchars(strip_tags($this->anexo3_nombre));
$this->anexo3_telefono=htmlspecialchars(strip_tags($this->anexo3_telefono));
$this->activo=htmlspecialchars(strip_tags($this->activo));
$this->id=htmlspecialchars(strip_tags($this->id));
		
$stmt->bindParam(":nombre", $this->nombre);
$stmt->bindParam(":apellido", $this->apellido);
$stmt->bindParam(":edad", $this->edad);
$stmt->bindParam(":fecha_nacimiento", $this->fecha_nacimiento);
$stmt->bindParam(":rut", $this->rut);
$stmt->bindParam(":profesion", $this->profesion);
$stmt->bindParam(":direccion", $this->direccion);
$stmt->bindParam(":telefono", $this->telefono);
$stmt->bindParam(":email", $this->email);
$stmt->bindParam(":vigilante", $this->vigilante);
$stmt->bindParam(":foto", $this->foto);
$stmt->bindParam(":clave_app", $this->clave_app);
$stmt->bindParam(":token", $this->token);
$stmt->bindParam(":anexo1_nombre", $this->anexo1_nombre);
$stmt->bindParam(":anexo1_telefono", $this->anexo1_telefono);
$stmt->bindParam(":anexo2_nombre", $this->anexo2_nombre);
$stmt->bindParam(":anexo2_telefono", $this->anexo2_telefono);
$stmt->bindParam(":anexo3_nombre", $this->anexo3_nombre);
$stmt->bindParam(":anexo3_telefono", $this->anexo3_telefono);
$stmt->bindParam(":activo", $this->activo);
$stmt->bindParam(":id", $this->id);
		$stmt->execute();

	 if($stmt->rowCount()) {
			return true;
		} else {
		   return false;
		}
	}
	function update_patch($jsonObj) {
			$query ="UPDATE ".$this->table_name. " SET ";
			$setValue="";
			$colCount=1;
			foreach($jsonObj as $key => $value) 
			{
				$columnName=htmlspecialchars(strip_tags($key));
				if($columnName!='id'){
				if($colCount===1){
					$setValue = $columnName."=:".$columnName;
				}else{
					$setValue = $setValue . "," .$columnName."=:".$columnName;
				}
				$colCount++;
				}
			}
			$setValue = rtrim($setValue,',');
			$query = $query . " " . $setValue . " WHERE id = :id"; 
			$stmt = $this->conn->prepare($query);
			foreach($jsonObj as $key => $value) 
			{
			    $columnName=htmlspecialchars(strip_tags($key));
				if($columnName!='id'){
				$colValue=htmlspecialchars(strip_tags($value));
				$stmt->bindValue(":".$columnName, $colValue);
				}
			}
			$stmt->bindParam(":id", $this->id);
			$stmt->execute();

			if($stmt->rowCount()) {
				return true;
			} else {
				return false;
			}
	}
	function delete(){
		$query = "DELETE FROM " . $this->table_name . " WHERE id = ? ";
		$stmt = $this->conn->prepare($query);
		$this->id=htmlspecialchars(strip_tags($this->id));

		$stmt->bindParam(1, $this->id);

	 	$stmt->execute();

	 if($stmt->rowCount()) {
			return true;
		} else {
		   return false;
		}
		 
	}
	
	
	
	
	
	
	// Guardar ubicacin en tiempo real en una tabla aparte
public function saveRealTimeLocation() {
    try {
        // Crear tabla si no existe
        $query = "CREATE TABLE IF NOT EXISTS vecinos_ubicacion (
            id INT AUTO_INCREMENT PRIMARY KEY,
            id_vecino INT NOT NULL,
            latitud DECIMAL(10,8) NOT NULL,
            longitud DECIMAL(11,8) NOT NULL,
            precision VARCHAR(20) DEFAULT 'normal',
            timestamp TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            INDEX (id_vecino),
            INDEX (timestamp),
            FOREIGN KEY (id_vecino) REFERENCES vecinos(id) ON DELETE CASCADE
        )";
        $this->conn->exec($query);
        
        // Insertar ubicacin en tiempo real
        $query = "INSERT INTO vecinos_ubicacion (id_vecino, latitud, longitud, precision) 
                  VALUES (:id_vecino, :latitud, :longitud, :precision)";
        
        $precision = isset($this->precision) ? $this->precision : 'normal';
        
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(':id_vecino', $this->id);
        $stmt->bindParam(':latitud', $this->latitud);
        $stmt->bindParam(':longitud', $this->longitud);
        $stmt->bindParam(':precision', $precision);
        
        if ($stmt->execute()) {
            // Limitar histrico a las ltimas 20 ubicaciones por usuario
            $query = "DELETE FROM vecinos_ubicacion 
                      WHERE id_vecino = :id_vecino 
                      AND id NOT IN (
                          SELECT id FROM (
                              SELECT id FROM vecinos_ubicacion 
                              WHERE id_vecino = :id_vecino 
                              ORDER BY timestamp DESC 
                              LIMIT 20
                          ) temp
                      )";
            
            $stmt = $this->conn->prepare($query);
            $stmt->bindParam(':id_vecino', $this->id);
            $stmt->execute();
            
            return true;
        }
        return false;
    } catch (Exception $e) {
        // Error silencioso para no interrumpir el flujo principal
        return false;
    }
}

// Mtodo auxiliar para obtener voluntarios cercanos usando ubicacin en tiempo real
public function getNearbyVolunteers($latitude, $longitude, $radius, $useRealTimeLocation = true, $maxInactiveMinutes = 15) {
    // Definir tiempo mximo de inactividad
    $maxInactiveTimestamp = date('Y-m-d H:i:s', strtotime("-$maxInactiveMinutes minutes"));
    
    if ($useRealTimeLocation) {
        // Consulta priorizando ubicacin en tiempo real
        $query = "SELECT v.id, v.nombre, v.apellido, v.telefono, v.push_token, 
                vu.latitud, vu.longitud, vu.timestamp,
                CASE 
                    WHEN vu.id IS NOT NULL AND vu.timestamp > :max_inactive_timestamp THEN 1 
                    ELSE 0 
                END as ubicacion_tiempo_real,
                vu.timestamp as ultima_actividad,
                (
                    6371 * acos(
                        cos(radians(:latitude)) * cos(radians(COALESCE(vu.latitud, v.latitud))) *
                        cos(radians(COALESCE(vu.longitud, v.longitud)) - radians(:longitude)) +
                        sin(radians(:latitude)) * sin(radians(COALESCE(vu.latitud, v.latitud)))
                    )
                ) AS distancia
            FROM vecinos v
            LEFT JOIN (
                SELECT vu1.* 
                FROM vecinos_ubicacion vu1
                INNER JOIN (
                    SELECT id_vecino, MAX(timestamp) as max_timestamp 
                    FROM vecinos_ubicacion 
                    GROUP BY id_vecino
                ) vu2 
                ON vu1.id_vecino = vu2.id_vecino AND vu1.timestamp = vu2.max_timestamp
            ) vu ON v.id = vu.id_vecino
            WHERE v.vigilante = 1 AND v.activo = 1
            HAVING distancia <= :radius
            ORDER BY ubicacion_tiempo_real DESC, distancia ASC";
            
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(':max_inactive_timestamp', $maxInactiveTimestamp);
    } else {
        // Consulta usando solo direcciones registradas (fallback)
        $query = "SELECT v.id, v.nombre, v.apellido, v.telefono, v.push_token,
                v.latitud, v.longitud, NULL as timestamp,
                0 as ubicacion_tiempo_real, NULL as ultima_actividad,
                (
                    6371 * acos(
                        cos(radians(:latitude)) * cos(radians(v.latitud)) *
                        cos(radians(v.longitud) - radians(:longitude)) +
                        sin(radians(:latitude)) * sin(radians(v.latitud))
                    )
                ) AS distancia
            FROM vecinos v
            WHERE v.vigilante = 1 AND v.activo = 1
            AND v.latitud IS NOT NULL AND v.longitud IS NOT NULL
            HAVING distancia <= :radius
            ORDER BY distancia ASC";
            
        $stmt = $this->conn->prepare($query);
    }
    
    $stmt->bindParam(':latitude', $latitude);
    $stmt->bindParam(':longitude', $longitude);
    $stmt->bindParam(':radius', $radius);
    $stmt->execute();
    
    return $stmt;
}
	
	
	
	

// A09adir este mtodo a la clase Vecinos
public function updateLocation(){
    // Consulta para actualizar solo los campos de ubicacin
    $query = "UPDATE " . $this->table_name . "
            SET
                latitud = :latitud,
                longitud = :longitud
            WHERE id = :id";
    
    // Preparar la consulta
    $stmt = $this->conn->prepare($query);
    
    // Sanitizar valores
    $this->id = htmlspecialchars(strip_tags($this->id));
    $this->latitud = htmlspecialchars(strip_tags($this->latitud));
    $this->longitud = htmlspecialchars(strip_tags($this->longitud));
    
    // Vincular valores
    $stmt->bindParam(":id", $this->id);
    $stmt->bindParam(":latitud", $this->latitud);
    $stmt->bindParam(":longitud", $this->longitud);
    
    // Ejecutar la consulta
    if($stmt->execute()){
        return true;
    }
    
    return false;
}

	
}
?>
