<?php
include_once '../config/header.php';
include_once '../config/helper.php';
include_once '../config/database.php';
include_once '../objects/alertas.php';
include_once '../token/validatetoken.php';
$database = new Database();
$db = $database->getConnection();

$alertas = new Alertas($db);

$data = json_decode(file_get_contents("php://input"));
$orAnd = isset($_GET['orAnd']) ? $_GET['orAnd'] : "OR";

$alertas->pageNo = isset($_GET['pageno']) ? $_GET['pageno'] : 1;
$alertas->no_of_records_per_page = isset($_GET['pagesize']) ? $_GET['pagesize'] : 30;

$stmt = $alertas->searchByColumn($data,$orAnd);

$num = $stmt->rowCount();
if($num>0){
    $alertas_arr=array();
	$alertas_arr["pageno"]=$alertas->pageNo;
	$alertas_arr["pagesize"]=$alertas->no_of_records_per_page;
    $alertas_arr["total_count"]=$alertas->search_record_count($data,$orAnd);
    $alertas_arr["records"]=array();
    
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)){
        extract($row);
 
        $alertas_item=array(
            
"id" => $id,
"usuario_id" => $usuario_id,
"tipo_alerta" => $tipo_alerta,
"estado" => $estado,
"fecha_creacion" => $fecha_creacion,
"fecha_resolucion" => $fecha_resolucion,
"latitud" => $latitud,
"longitud" => $longitud
        );
 
        array_push($alertas_arr["records"], $alertas_item);
    }
    http_response_code(200);
	echo json_encode(array("status" => "success", "code" => 1,"message"=> "alertas found","document"=> $alertas_arr));
    
}else{
    http_response_code(404);
	echo json_encode(array("status" => "error", "code" => 0,"message"=> "No alertas found.","document"=> ""));
}
 


