<?php
include_once '../config/header.php';
include_once '../config/helper.php';
include_once '../config/database.php';
include_once '../objects/eventos_alerta.php';
include_once '../token/validatetoken.php';

$database = new Database();
$db = $database->getConnection();

$eventos_alerta = new Eventos_Alerta($db);

$eventos_alerta->pageNo = isset($_GET['pageno']) ? $_GET['pageno'] : 1;
$eventos_alerta->no_of_records_per_page = isset($_GET['pagesize']) ? $_GET['pagesize'] : 30;
$eventos_alerta->alerta_id = isset($_GET['alerta_id']) ? $_GET['alerta_id'] : die();

$stmt = $eventos_alerta->readByalerta_id();
$num = $stmt->rowCount();

if($num>0){
    $eventos_alerta_arr=array();
	$eventos_alerta_arr["pageno"]=$eventos_alerta->pageNo;
	$eventos_alerta_arr["pagesize"]=$eventos_alerta->no_of_records_per_page;
    $eventos_alerta_arr["total_count"]=$eventos_alerta->total_record_count();
    $eventos_alerta_arr["records"]=array();
    
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)){
        extract($row);
 
        $eventos_alerta_item=array(
            
"id" => $id,
"alerta_id" => $alerta_id,
"tipo_evento" => $tipo_evento,
"descripcion_evento" => html_entity_decode($descripcion_evento),
"fecha_evento" => $fecha_evento
        );
        array_push($eventos_alerta_arr["records"], $eventos_alerta_item);
    }
    http_response_code(200);
	echo json_encode(array("status" => "success", "code" => 1,"message"=> "eventos_alerta found","document"=> $eventos_alerta_arr));
    
}else{
    http_response_code(404);
	echo json_encode(array("status" => "error", "code" => 0,"message"=> "No eventos_alerta found.","document"=> ""));
}
 


