<?php
require __DIR__ . '/vendor/autoload.php';

use Kreait\Firebase\Factory;
use Kreait\Firebase\Messaging\CloudMessage;
use Kreait\Firebase\Messaging\Notification;
use Kreait\Firebase\Messaging\ApnsConfig;
use Kreait\Firebase\Messaging\ApnsPayload;
use Kreait\Firebase\Messaging\Aps;

$serviceAccountPath = __DIR__ . '/assets/parqueschottprotegidoapp-firebase-adminsdk-fbsvc-0f1a4db5b0.json';

// Crear instancia de Firebase
$factory = (new Factory)->withServiceAccount($serviceAccountPath);
$messaging = $factory->createMessaging();

// Token del dispositivo (iOS)
$deviceToken = 'ePUaWzj26E2Xi0vFtVYi5Q:APA91bEfgH-aJpGAx5cUjo5dlY5yebjsmqZt0MfTQVzCZifzUdvneXbOIhHHMKgRXCarPH5z7rsA45paFDQhb2dSv8PkQxep4XsjwnH8kHeoThuIi-etV10';

// Configuración para APNs (iOS)
$apnsConfig = ApnsConfig::fromArray([
    'headers' => [
        'apns-priority' => '10'
    ],
    'payload' => [
        'aps' => [
            'alert' => [
                'title' => '🚨 Notificación de prueba',
                'body' => 'Esto es una notificación para iOS via PHP'
            ],
            'sound' => 'default',
            'badge' => 1
        ]
    ]
]);

// Crear mensaje
$message = CloudMessage::withTarget('token', $deviceToken)
    ->withNotification(Notification::create('🚨 Notificación de prueba', 'Esto es una notificación para iOS via PHP'))
    ->withApnsConfig($apnsConfig);

// Enviar
try {
    $response = $messaging->send($message);
    echo json_encode(['status' => 'success', 'response' => $response]);
} catch (Exception $e) {
    echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
}
