<?php
// Configurar funcin de logging
function logToFile($message) {
    $logPath = 'fcm_logs/';
    
    // Asegurar que el directorio existe
    if (!file_exists($logPath)) {
        mkdir($logPath, 0755, true);
    }
    
    $logFile = $logPath . 'fcm_log_' . date('Y-m-d') . '.log';
    $timestamp = date('Y-m-d H:i:s');
    $logMessage = "[$timestamp] $message" . PHP_EOL;
    
    // Escribir al archivo de log
    file_put_contents($logFile, $logMessage, FILE_APPEND);
}

// Resto del cdigo existente
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

// Incluir archivos necesarios
include_once '../config/database.php';
include_once '../token/validatetoken.php';
require 'vendor/autoload.php'; // Para Firebase Admin SDK
use Kreait\Firebase\Factory;
use Kreait\Firebase\Messaging\CloudMessage;

// Obtener la conexin a la base de datos
$database = new Database();
$db = $database->getConnection();

// Obtener datos del cuerpo de la solicitud
$data = json_decode(file_get_contents("php://input"), true); // Convertir a array asociativo
logToFile("Solicitud recibida: " . json_encode($data));

if (!empty($data['notification'])) {
    // Configurar Firebase
    $serviceAccountPath = 'assets/parqueschottprotegidoapp-firebase-adminsdk-fbsvc-b3cf234faf.json'; // Ruta al archivo JSON de credenciales
    
    if (!file_exists($serviceAccountPath)) {
        logToFile("ERROR: No se encuentra el archivo de credenciales en $serviceAccountPath");
        http_response_code(500);
        echo json_encode(array("status" => "error", "code" => 0, "message" => "No se encuentra el archivo de credenciales.", "document" => ""));
        exit;
    }
    
    try {
        logToFile("Iniciando configuracin de Firebase con cuenta de servicio: $serviceAccountPath");
        $factory = (new Factory)->withServiceAccount($serviceAccountPath);
        $messaging = $factory->createMessaging();
        
        // Crear el mensaje de notificacin basado en el array completo del payload recibido
        logToFile("Construyendo mensaje CloudMessage");
        $message = CloudMessage::fromArray($data); // Adaptar todo el payload recibido
        
        // Enviar la notificacin
        logToFile("Enviando mensaje a Firebase...");
        $response = $messaging->send($message);
        
        logToFile("Respuesta exitosa de Firebase: " . json_encode($response));
        http_response_code(201);
        echo json_encode(array("status" => "success", "code" => 1, "message" => "Sent Successfully", "document" => $response));
    } catch (Exception $e) {
        logToFile("ERROR al enviar notificacin: " . $e->getMessage() . "\n" . $e->getTraceAsString());
        http_response_code(503);
        echo json_encode(array("status" => "error", "code" => 0, "message" => "Failed to send notification", "document" => $e->getMessage()));
    }
} else {
    // Si faltan campos requeridos, responder con un error 400
    logToFile("ERROR: Datos incompletos, falta campo 'notification'");
    http_response_code(400);
    echo json_encode(array("status" => "error", "code" => 0, "message" => "Data is incomplete.", "document" => ""));
}
?>