<?php
include_once '../config/header.php';
include_once '../config/helper.php';
include_once '../config/database.php';
include_once '../objects/vecinos.php';
include_once '../token/validatetoken.php';
$database = new Database();
$db = $database->getConnection();

$vecinos = new Vecinos($db);

$data = json_decode(file_get_contents("php://input"));
$orAnd = isset($_GET['orAnd']) ? $_GET['orAnd'] : "OR";

$vecinos->pageNo = isset($_GET['pageno']) ? $_GET['pageno'] : 1;
$vecinos->no_of_records_per_page = isset($_GET['pagesize']) ? $_GET['pagesize'] : 30;

$stmt = $vecinos->searchByColumn($data,$orAnd);

$num = $stmt->rowCount();
if($num>0){
    $vecinos_arr=array();
	$vecinos_arr["pageno"]=$vecinos->pageNo;
	$vecinos_arr["pagesize"]=$vecinos->no_of_records_per_page;
    $vecinos_arr["total_count"]=$vecinos->search_record_count($data,$orAnd);
    $vecinos_arr["records"]=array();
    
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)){
        extract($row);
 
        $vecinos_item=array(
            
"id" => $id,
"nombre" => html_entity_decode($nombre),
"apellido" => html_entity_decode($apellido),
"edad" => $edad,
"fecha_nacimiento" => html_entity_decode($fecha_nacimiento),
"rut" => $rut,
"profesion" => html_entity_decode($profesion),
"direccion" => html_entity_decode($direccion),
"telefono" => html_entity_decode($telefono),
"email" => html_entity_decode($email),
"vigilante" => $vigilante,
"foto" => html_entity_decode($foto),
"clave_app" => html_entity_decode($clave_app),
"token" => html_entity_decode($token),
"anexo1_nombre" => html_entity_decode($anexo1_nombre),
"anexo1_telefono" => $anexo1_telefono,
"anexo2_nombre" => html_entity_decode($anexo2_nombre),
"anexo2_telefono" => $anexo2_telefono,
"anexo3_nombre" => html_entity_decode($anexo3_nombre),
"anexo3_telefono" => $anexo3_telefono,
"activo" => $activo
        );
 
        array_push($vecinos_arr["records"], $vecinos_item);
    }
    http_response_code(200);
	echo json_encode(array("status" => "success", "code" => 1,"message"=> "vecinos found","document"=> $vecinos_arr));
    
}else{
    http_response_code(404);
	echo json_encode(array("status" => "error", "code" => 0,"message"=> "No vecinos found.","document"=> ""));
}
 


