<?php
include_once '../config/header.php';
include_once '../config/helper.php';
include_once '../config/database.php';
include_once '../objects/vecinos_anexos.php';
include_once '../token/validatetoken.php';
$database = new Database();
$db = $database->getConnection();

$vecinos_anexos = new Vecinos_Anexos($db);

$data = json_decode(file_get_contents("php://input"));
$orAnd = isset($_GET['orAnd']) ? $_GET['orAnd'] : "OR";

$vecinos_anexos->pageNo = isset($_GET['pageno']) ? $_GET['pageno'] : 1;
$vecinos_anexos->no_of_records_per_page = isset($_GET['pagesize']) ? $_GET['pagesize'] : 30;

$stmt = $vecinos_anexos->searchByColumn($data,$orAnd);

$num = $stmt->rowCount();
if($num>0){
    $vecinos_anexos_arr=array();
	$vecinos_anexos_arr["pageno"]=$vecinos_anexos->pageNo;
	$vecinos_anexos_arr["pagesize"]=$vecinos_anexos->no_of_records_per_page;
    $vecinos_anexos_arr["total_count"]=$vecinos_anexos->search_record_count($data,$orAnd);
    $vecinos_anexos_arr["records"]=array();
    
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)){
        extract($row);
 
        $vecinos_anexos_item=array(
            
"id" => $id,
"rut" => $rut,
"nombre" => html_entity_decode($nombre),
"apellido" => html_entity_decode($apellido),
"clave_app" => html_entity_decode($clave_app),
"id_vecino" => $id_vecino
        );
 
        array_push($vecinos_anexos_arr["records"], $vecinos_anexos_item);
    }
    http_response_code(200);
	echo json_encode(array("status" => "success", "code" => 1,"message"=> "vecinos_anexos found","document"=> $vecinos_anexos_arr));
    
}else{
    http_response_code(404);
	echo json_encode(array("status" => "error", "code" => 0,"message"=> "No vecinos_anexos found.","document"=> ""));
}
 


