<?php
include_once '../config/header.php';
include_once '../config/helper.php';
include_once '../config/database.php';
include_once '../objects/vecinos.php';
include_once '../token/validatetoken.php';

// Inicializamos la conexión a la base de datos
$database = new Database();
$db = $database->getConnection();
$vecinos = new Vecinos($db);

// Obtener parámetros
$latitude = isset($_GET['latitude']) ? floatval($_GET['latitude']) : 0;
$longitude = isset($_GET['longitude']) ? floatval($_GET['longitude']) : 0;
$radius = isset($_GET['radius']) ? floatval($_GET['radius']) : 3;
$useRealTimeLocation = isset($_GET['usar_ubicacion_tiempo_real']) ? 
                        filter_var($_GET['usar_ubicacion_tiempo_real'], FILTER_VALIDATE_BOOLEAN) : true;
$maxInactiveMinutes = isset($_GET['max_inactividad_minutos']) ? intval($_GET['max_inactividad_minutos']) : 15;
$includeDetails = isset($_GET['incluir_detalles']) ? 
                        filter_var($_GET['incluir_detalles'], FILTER_VALIDATE_BOOLEAN) : false;

// Ejecutar consulta usando el método del objeto Vecinos
$stmt = $vecinos->getNearbyVolunteers($latitude, $longitude, $radius, 
                                       $useRealTimeLocation, $maxInactiveMinutes);

$num = $stmt->rowCount();
if ($num > 0) {
    $vecinos_arr = array();
    $vecinos_arr["records"] = array();
    
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        // Limitar a solo el primer nombre para privacidad
        $nombre_partes = explode(' ', $row['nombre']);
        $primer_nombre = $nombre_partes[0];
        
        $voluntario_item = array(
            "id" => $row['id'],
            "nombre" => $primer_nombre,
            "distancia" => round($row['distancia'], 2),
            "push_token" => $row['push_token']
        );
        
        // Incluir detalles adicionales si se solicitaron
        if ($includeDetails) {
            $voluntario_item["ubicacion_tiempo_real"] = (bool)$row['ubicacion_tiempo_real'];
            $voluntario_item["ultima_actividad"] = $row['timestamp'];
            $voluntario_item["latitud"] = $row['latitud'];
            $voluntario_item["longitud"] = $row['longitud'];
            $voluntario_item["nombre_completo"] = $row['nombre'] . ' ' . $row['apellido'];
        }
        
        array_push($vecinos_arr["records"], $voluntario_item);
    }
    
    http_response_code(200);
    echo json_encode(array(
        "status" => "success", 
        "code" => 1,
        "message" => "Voluntarios cercanos encontrados",
        "document" => $vecinos_arr
    ));
} else {
    http_response_code(200);
    echo json_encode(array(
        "status" => "success", 
        "code" => 0,
        "message" => "No se encontraron voluntarios cercanos en el radio especificado.",
        "document" => array("records" => array())
    ));
}
?>