<?php
class Eventos_Alerta{
 
    private $conn;
    private $table_name = "eventos_alerta";
	public $pageNo = 1;
	public  $no_of_records_per_page=30;
	
public $id;
public $alerta_id;
public $tipo_evento;
public $descripcion_evento;
public $fecha_evento;
public $usuario_id;
    
    public function __construct($db){
        $this->conn = $db;
    }

	function total_record_count() {
		$query = "select count(1) as total from ". $this->table_name ."";
		$stmt = $this->conn->prepare($query);
		$stmt->execute();
		$row = $stmt->fetch(PDO::FETCH_ASSOC);
		return $row['total'];
	}

	function search_count($searchKey) {
		$query = "SELECT count(1) as total FROM ". $this->table_name ." t  join alertas ww on t.alerta_id = ww.id  WHERE LOWER(t.alerta_id) LIKE ? OR LOWER(t.tipo_evento) LIKE ?  OR LOWER(t.descripcion_evento) LIKE ?  OR LOWER(t.fecha_evento) LIKE ? ";
		$stmt = $this->conn->prepare($query);
		$searchKey="%".strtolower($searchKey)."%";
		
$stmt->bindParam(1, $searchKey);
$stmt->bindParam(2, $searchKey);
$stmt->bindParam(3, $searchKey);
$stmt->bindParam(4, $searchKey);
		$stmt->execute();
		$row = $stmt->fetch(PDO::FETCH_ASSOC);
		return $row['total'];
	}
	
	function search_record_count($columnArray,$orAnd){
		$where="";
		$paramCount = 1;
		foreach ($columnArray as $col) {
			$pre_param = "P" . $paramCount . "_";
			$columnName=htmlspecialchars(strip_tags($col->columnName));
			$columnLogic=$col->columnLogic;
			if($where==""){
				$where="LOWER(t.".$columnName . ") ".$columnLogic." :".$pre_param.$columnName;
			}else{
				$where=$where." ". $orAnd ." LOWER(t." . $columnName . ") ".$columnLogic." :".$pre_param.$columnName;
			}
			 $paramCount++;
		}
		$query = "SELECT count(1) as total FROM ". $this->table_name ." t  join alertas ww on t.alerta_id = ww.id  WHERE ".$where."";
		
		$stmt = $this->conn->prepare($query);
		$paramCount=1;
		foreach ($columnArray as $col) {
			$columnName=htmlspecialchars(strip_tags($col->columnName));
		if(strtoupper($col->columnLogic)=="LIKE"){
		$columnValue="%".strtolower($col->columnValue)."%";
		}else{
		$columnValue=strtolower($col->columnValue);
		}
			$stmt->bindValue(":".$pre_param.$columnName, $columnValue);
			$paramCount++;
		}
		
		$stmt->execute();
		$row = $stmt->fetch(PDO::FETCH_ASSOC);
		 $num = $stmt->rowCount();
		if($num>0){
			return $row['total'];
		}else{
			return 0;
		}
	}
	function read(){
		if(isset($_GET["pageNo"])){
			$this->pageNo=$_GET["pageNo"];
		}
		$offset = ($this->pageNo-1) * $this->no_of_records_per_page; 
		$query = "SELECT  ww.usuario_id, t.* FROM ". $this->table_name ." t  join alertas ww on t.alerta_id = ww.id  LIMIT ".$offset." , ". $this->no_of_records_per_page."";
		$stmt = $this->conn->prepare($query);
		$stmt->execute();
		return $stmt;
	}
	function search($searchKey){
		if(isset($_GET["pageNo"])){
		$this->pageNo=$_GET["pageNo"];
		}
		$offset = ($this->pageNo-1) * $this->no_of_records_per_page; 
		$query = "SELECT  ww.usuario_id, t.* FROM ". $this->table_name ." t  join alertas ww on t.alerta_id = ww.id  WHERE LOWER(t.alerta_id) LIKE ? OR LOWER(t.tipo_evento) LIKE ?  OR LOWER(t.descripcion_evento) LIKE ?  OR LOWER(t.fecha_evento) LIKE ?  LIMIT ".$offset." , ". $this->no_of_records_per_page."";
		$stmt = $this->conn->prepare($query);
		$searchKey="%".strtolower($searchKey)."%";
		
$stmt->bindParam(1, $searchKey);
$stmt->bindParam(2, $searchKey);
$stmt->bindParam(3, $searchKey);
$stmt->bindParam(4, $searchKey);
		$stmt->execute();
		return $stmt;
	}
	function searchByColumn($columnArray,$orAnd){
		if(isset($_GET["pageNo"])){
		$this->pageNo=$_GET["pageNo"];
		}
		$offset = ($this->pageNo-1) * $this->no_of_records_per_page; 
		$where="";
		$paramCount = 1;
		foreach ($columnArray as $col) {
			$pre_param = "P" . $paramCount . "_";
			$columnName=htmlspecialchars(strip_tags($col->columnName));
			$columnLogic=$col->columnLogic;
			if($where==""){
				$where="LOWER(t.".$columnName . ") ".$columnLogic." :".$pre_param.$columnName;
			}else{
				$where=$where." ". $orAnd ." LOWER(t." . $columnName . ") ".$columnLogic." :".$pre_param.$columnName;
			}
			 $paramCount++;
		}
		$query = "SELECT  ww.usuario_id, t.* FROM ". $this->table_name ." t  join alertas ww on t.alerta_id = ww.id  WHERE ".$where." LIMIT ".$offset." , ". $this->no_of_records_per_page."";
		
		$stmt = $this->conn->prepare($query);
		$paramCount=1;
		foreach ($columnArray as $col) {
			$pre_param = "P" . $paramCount . "_";
			$columnName=htmlspecialchars(strip_tags($col->columnName));
			if(strtoupper($col->columnLogic)=="LIKE"){
			$columnValue="%".strtolower($col->columnValue)."%";
			}else{
			$columnValue=strtolower($col->columnValue);
			}
			$stmt->bindValue(":".$pre_param.$columnName, $columnValue);
			$paramCount++;
		}
		
		$stmt->execute();
		return $stmt;
	}
	
	

	function readOne(){
		$query = "SELECT  ww.usuario_id, t.* FROM ". $this->table_name ." t  join alertas ww on t.alerta_id = ww.id  WHERE t.id = ? LIMIT 0,1";
		$stmt = $this->conn->prepare($query);
		$stmt->bindParam(1, $this->id);
		$stmt->execute();
		$row = $stmt->fetch(PDO::FETCH_ASSOC);
		$num = $stmt->rowCount();
		if($num>0){
			
$this->id = $row['id'];
$this->alerta_id = $row['alerta_id'];
$this->usuario_id = $row['usuario_id'];
$this->tipo_evento = $row['tipo_evento'];
$this->descripcion_evento = $row['descripcion_evento'];
$this->fecha_evento = $row['fecha_evento'];
		}
		else{
			$this->id=null;
		}
	}
	function create(){
		$query ="INSERT INTO ".$this->table_name." SET alerta_id=:alerta_id,tipo_evento=:tipo_evento,descripcion_evento=:descripcion_evento,fecha_evento=:fecha_evento";
		$stmt = $this->conn->prepare($query);
		
$this->alerta_id=htmlspecialchars(strip_tags($this->alerta_id));
$this->tipo_evento=htmlspecialchars(strip_tags($this->tipo_evento));
$this->descripcion_evento=htmlspecialchars(strip_tags($this->descripcion_evento));
$this->fecha_evento=htmlspecialchars(strip_tags($this->fecha_evento));
		
$stmt->bindParam(":alerta_id", $this->alerta_id);
$stmt->bindParam(":tipo_evento", $this->tipo_evento);
$stmt->bindParam(":descripcion_evento", $this->descripcion_evento);
$stmt->bindParam(":fecha_evento", $this->fecha_evento);
		$lastInsertedId=0;
		if($stmt->execute()){
			$lastInsertedId = $this->conn->lastInsertId();
			if($lastInsertedId==0 && $this->id!=null){
				$this->readOne();
				if($this->id!=null){
					$lastInsertedId=$this->id;
					}
			}
		}
	
		return $lastInsertedId;
	}
	function update(){
		$query ="UPDATE ".$this->table_name." SET alerta_id=:alerta_id,tipo_evento=:tipo_evento,descripcion_evento=:descripcion_evento,fecha_evento=:fecha_evento WHERE id = :id";
		$stmt = $this->conn->prepare($query);
		
$this->alerta_id=htmlspecialchars(strip_tags($this->alerta_id));
$this->tipo_evento=htmlspecialchars(strip_tags($this->tipo_evento));
$this->descripcion_evento=htmlspecialchars(strip_tags($this->descripcion_evento));
$this->fecha_evento=htmlspecialchars(strip_tags($this->fecha_evento));
$this->id=htmlspecialchars(strip_tags($this->id));
		
$stmt->bindParam(":alerta_id", $this->alerta_id);
$stmt->bindParam(":tipo_evento", $this->tipo_evento);
$stmt->bindParam(":descripcion_evento", $this->descripcion_evento);
$stmt->bindParam(":fecha_evento", $this->fecha_evento);
$stmt->bindParam(":id", $this->id);
		$stmt->execute();

	 if($stmt->rowCount()) {
			return true;
		} else {
		   return false;
		}
	}
	function update_patch($jsonObj) {
			$query ="UPDATE ".$this->table_name. " SET ";
			$setValue="";
			$colCount=1;
			foreach($jsonObj as $key => $value) 
			{
				$columnName=htmlspecialchars(strip_tags($key));
				if($columnName!='id'){
				if($colCount===1){
					$setValue = $columnName."=:".$columnName;
				}else{
					$setValue = $setValue . "," .$columnName."=:".$columnName;
				}
				$colCount++;
				}
			}
			$setValue = rtrim($setValue,',');
			$query = $query . " " . $setValue . " WHERE id = :id"; 
			$stmt = $this->conn->prepare($query);
			foreach($jsonObj as $key => $value) 
			{
			    $columnName=htmlspecialchars(strip_tags($key));
				if($columnName!='id'){
				$colValue=htmlspecialchars(strip_tags($value));
				$stmt->bindValue(":".$columnName, $colValue);
				}
			}
			$stmt->bindParam(":id", $this->id);
			$stmt->execute();

			if($stmt->rowCount()) {
				return true;
			} else {
				return false;
			}
	}
	function delete(){
		$query = "DELETE FROM " . $this->table_name . " WHERE id = ? ";
		$stmt = $this->conn->prepare($query);
		$this->id=htmlspecialchars(strip_tags($this->id));

		$stmt->bindParam(1, $this->id);

	 	$stmt->execute();

	 if($stmt->rowCount()) {
			return true;
		} else {
		   return false;
		}
		 
	}

	
function readByalerta_id(){

if (isset($_GET["pageNo"]))
{
$this->pageNo =$_GET["pageNo"]; } 
$offset = ($this->pageNo - 1) * $this->no_of_records_per_page;
$query = "SELECT  ww.usuario_id, t.* FROM ". $this->table_name ." t  join alertas ww on t.alerta_id = ww.id  WHERE t.alerta_id = ? LIMIT ".$offset." , ". $this->no_of_records_per_page."";

$stmt = $this->conn->prepare( $query );
$stmt->bindParam(1, $this->alerta_id);

$stmt->execute();
return $stmt;
}

}
?>
