<?php
include_once '../config/header.php';
include_once '../config/helper.php';
include_once '../config/database.php';
include_once '../objects/vecinos.php';
include_once '../token/validatetoken.php';

// Inicializar la conexin a la base de datos
$database = new Database();
$db = $database->getConnection();

$vecinos = new Vecinos($db);

// Obtener datos de la solicitud
$data = json_decode(file_get_contents("php://input"));

// Validar datos necesarios
if(!isset($data->id) || !isset($data->latitud) || !isset($data->longitud)){
    http_response_code(400);
    echo json_encode(array(
        "status" => "error",
        "code" => 0,
        "message" => "Faltan datos requeridos (id, latitud, longitud).",
        "document" => ""
    ));
    exit();
}

// Asignar valores al objeto
$vecinos->id = $data->id;
$vecinos->latitud = $data->latitud;
$vecinos->longitud = $data->longitud;

// Agregar precisin si est disponible
if(isset($data->precision)) {
    $vecinos->precision = $data->precision;
}

// Guardar ubicacin en tiempo real (si es voluntario o si la opcin est habilitada)
$realTimeSaved = false;
if(isset($data->es_voluntario) && $data->es_voluntario == 1) {
    $realTimeSaved = $vecinos->saveRealTimeLocation();
}

// Actualizar la ubicacin en la tabla principal
if($vecinos->updateLocation()){
    http_response_code(200);
    echo json_encode(array(
        "status" => "success",
        "code" => 1,
        "message" => "Ubicacin actualizada correctamente." . 
                    ($realTimeSaved ? " Historial de ubicaciones actualizado." : ""),
        "document" => ""
    ));
} else {
    http_response_code(500);
    echo json_encode(array(
        "status" => "error",
        "code" => 0,
        "message" => "No se pudo actualizar la ubicacin.",
        "document" => ""
    ));
}
?>