<?php
include_once '../config/header.php';
include_once '../config/helper.php';
include_once '../config/database.php';
include_once '../objects/vecinos.php';
include_once '../token/validatetoken.php';

// Inicializar la conexión a la base de datos
$database = new Database();
$db = $database->getConnection();

// Obtener datos de la solicitud
$data = json_decode(file_get_contents("php://input"));

// Validar datos necesarios
if(!isset($data->id) || !isset($data->latitud) || !isset($data->longitud)){
    http_response_code(400);
    echo json_encode(array(
        "status" => "error",
        "code" => 0,
        "message" => "Faltan datos requeridos (id, latitud, longitud).",
        "document" => ""
    ));
    exit();
}

// Insertar ubicación en tiempo real
$query = "INSERT INTO vecinos_ubicacion (id_vecino, latitud, longitud, precision) 
          VALUES (:id_vecino, :latitud, :longitud, :precision)";

$precision = isset($data->precision) ? $data->precision : 'normal';

try {
    $stmt = $db->prepare($query);
    $stmt->bindParam(':id_vecino', $data->id);
    $stmt->bindParam(':latitud', $data->latitud);
    $stmt->bindParam(':longitud', $data->longitud);
    $stmt->bindParam(':precision', $precision);
    
    if ($stmt->execute()) {
        // Limitar histórico a las últimas 20 ubicaciones por usuario
        $query = "DELETE FROM vecinos_ubicacion 
                  WHERE id_vecino = :id_vecino 
                  AND id NOT IN (
                      SELECT id FROM (
                          SELECT id FROM vecinos_ubicacion 
                          WHERE id_vecino = :id_vecino 
                          ORDER BY timestamp DESC 
                          LIMIT 20
                      ) temp
                  )";
        
        $stmt = $db->prepare($query);
        $stmt->bindParam(':id_vecino', $data->id);
        $stmt->execute();
        
        http_response_code(200);
        echo json_encode(array(
            "status" => "success",
            "code" => 1,
            "message" => "Ubicación en tiempo real guardada correctamente.",
            "document" => ""
        ));
    } else {
        http_response_code(500);
        echo json_encode(array(
            "status" => "error",
            "code" => 0,
            "message" => "No se pudo guardar la ubicación en tiempo real.",
            "document" => ""
        ));
    }
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(array(
        "status" => "error",
        "code" => 0,
        "message" => "Error al guardar la ubicación: " . $e->getMessage(),
        "document" => ""
    ));
}
?>